<?php declare(strict_types=1);
/**
 * @author Ryan Spaeth <rspaeth@spaethtech.com>
 * @copyright 2025 - Spaeth Technologies, Archous Networks
 */

namespace SpaethTech\UCRM\SDK\Controllers;

use Psr\Http\Message\ResponseInterface as Response;

final class PluginController extends BaseController
{
  public function info(Response $response): Response
  {
    $server = $this->plugin->getServer();

    $data = [
      "id" => (string) $this->plugin->getId(),
      "version" => $this->plugin->getVersion(),
      "name" => $this->plugin->getName(),
      "hostname" => $server->getHostname(),
      "ucrm_api_url" => $server->getPublicUcrmApiUrl(),
      "ucrm_api_key" => $server->getUcrmToken(),
      "plugin_url" => $this->plugin->getPublicUrl() . ".php?",
    ];

    return $this->json($response, $data);
  }
}