<?php declare(strict_types=1);
/**
 * @author Ryan Spaeth <rspaeth@spaethtech.com>
 * @copyright 2025 - Spaeth Technologies, Archous Networks
 */

namespace SpaethTech\UCRM\SDK\Configs;

use SpaethTech\UCRM\SDK\Server;
use Symfony\Component\Yaml\Yaml;

class ServerParams extends Abstracts\ReadOnlyConfig
{
    public function __construct(protected Server $server)
    {
        parent::__construct("/usr/src/ucrm/app/config/parameters.yml");
        $this->load();
    }

    public function load(): self
    {
        $contents = file_get_contents($this->file);
        $this->data = Yaml::parse($contents)["parameters"];
        return $this;
    }

    public function getDatabaseHost(): string
    {
        return $this->data["database_host"];
    }

    public function getDatabasePort(): int
    {
        return $this->data["database_port"];
    }

    public function getDatabaseName(): string
    {
        return $this->data["database_name"];
    }

    public function getDatabaseUser(): string
    {
        return $this->data["database_user"];
    }

    public function getDatabasePassword(): string
    {
        return $this->data["database_password"];
    }

    // TODO: Add getters for other parameters, as needed.
}
