<?php declare(strict_types=1);
/**
 * @author Ryan Spaeth <rspaeth@spaethtech.com>
 * @copyright 2025 - Spaeth Technologies, Archous Networks
 */

namespace SpaethTech\UCRM\SDK\Configs;

use SpaethTech\UCRM\SDK\Plugin;

class PluginManifest extends Abstracts\ReadOnlyConfig
{
    public function __construct(protected Plugin $plugin)
    {
        parent::__construct($plugin->getPath("manifest.json"));
        $this->load();
    }

    public function load(): self
    {
        $this->data = json_decode(file_get_contents($this->file), true);
        return $this;
    }

    public function getName(): string
    {
        return $this->data["information"]["name"];
    }

    public function getVersion(): string
    {
        return $this->data["information"]["version"];
    }
}
