<?php declare(strict_types=1);
/**
 * @author Ryan Spaeth <rspaeth@spaethtech.com>
 * @copyright 2025 - Spaeth Technologies, Archous Networks
 */

//if (!defined("PUBLIC_PAGE") || !PUBLIC_PAGE)
 //   die("This page is not accessible from outside the plugin.");

//use SpaethTech\UCRM\SDK\Server;

use SpaethTech\UCRM\SDK\Plugin;

return function (Plugin $plugin, array $data): array
{
    $server = $plugin->getServer();
    // Prevent the need for calling back to the server for the service plans.
    $client = $server->getUcrmClient();
    $response = $client->get("service-plans?servicePlanType=internet");
    $service_plans = json_decode($response->getBody()->getContents(), true);
    $data["service_plans"] = array_map(function ($service_plan) {
        return [
            "id" => $service_plan["id"],
            "name" => $service_plan["name"],
        ];
    }, $service_plans);
    return $data;
};
