// Service sync for preemptive cleanup
(function () {
  const pathname = window.location.pathname;

  // Skip sync on client service pages - they handle their own sync directly
  const serviceMatch = pathname.match(/^\/crm\/client\/service\/(\d+)/);
  if (serviceMatch) {
    console.log(
      "[UISP] Skipping sync - client service page handles sync directly"
    );
    return;
  }

  // Trigger sync for all other pages to do preemptive cleanup
  console.log("[UISP] Triggering service sync for preemptive cleanup...");

  // Make the sync request to the plugin API (no auth needed)
  fetch("/crm/_plugins/provisioner-v2/public.php?/api/services/sync", {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
    body: JSON.stringify({}), // Sync all services
  })
    .then((response) => {
      if (!response.ok) {
        throw new Error(`Sync failed: ${response.status}`);
      }
      return response.json();
    })
    .then((data) => {
      console.log("[UISP] (/api/services/sync) Completed", data);
    })
    .catch((error) => {
      console.error("[UISP] (/api/services/sync) Error", error);
    });
})();
