<?php declare(strict_types=1);
/**
 * @author Ryan Spaeth <rspaeth@spaethtech.com>
 * @copyright 2025 - Spaeth Technologies, Archous Networks
 */

use SpaethTech\UCRM\SDK\Plugin;
use SpaethTech\UCRM\SDK\Server;

require_once __DIR__ . "/bootstrap.php";

$server = new Server();
$plugin = new Plugin($server);

// /**
//  * @var Server $server
//  * @var Plugin $plugin
//  */
// global $server, $plugin;

// Perform another registration to the provisioner.
//$server->register($plugin, $plugin->getConfig()->get("provisioner_url"));


try {

  echo "Starting...\n";
  //$test = $plugin->getProvisionerClient();
  // var_dump($test);

  $response = $plugin->getProvisionerClient()->put("provision", [
    "json" => [
      "instance_id" => $server->getInstanceId(),
      "hostname" => $server->getHostname(),
      "timestamp" => (new DateTime())->format("c"),
      "plugin" => [
        "id" => $plugin->getId(),
        "name" => $plugin->getName(),
        "version" => $plugin->getVersion(),
        "hostname" => $server->getHostname(),
        "ucrm_api_url" => $server->getPublicUcrmApiUrl(),
        "ucrm_api_key" => $server->getUcrmToken(),
        "plugin_url" => $plugin->getPublicUrl(),
      ],
      //"services" => get_services(),
    ],
  ]);

  echo $response->getStatusCode();

} catch (Exception $e) {
  echo $e->getMessage();
}