<?php declare(strict_types=1);
/**
 * @author Ryan Spaeth <rspaeth@spaethtech.com>
 * @copyright 2025 - Spaeth Technologies, Archous Networks
 */

use SpaethTech\UCRM\SDK\Plugin;
use SpaethTech\UCRM\SDK\Server;

require_once __DIR__ . "/bootstrap.php";

$server = new Server();
$plugin = new Plugin($server);

// Backup configuration, for comparing previous data in `hook_configure.php`.
copy($config_file = __DIR__ . "/data/config.json", "$config_file.bak");

// Perform initial registration to the provisioner.
$server->register($plugin, $plugin->getConfig()->get("provisioner_url"));

// Workflow Trigger
$response = $plugin->executeWorkflow("plugin/installed", [], true);
