<?php declare(strict_types=1);
/**
 * @author Ryan Spaeth <rspaeth@spaethtech.com>
 * @copyright 2025 - Spaeth Technologies, Archous Networks
 */

use GuzzleHttp\Client;
use SpaethTech\UCRM\SDK\Enums\ClientServiceWidgets;
use SpaethTech\UCRM\SDK\Plugin;
use SpaethTech\UCRM\SDK\Server;

require_once __DIR__ . "/bootstrap.php";


//file_put_contents("data/plugin.log", "Cleared log on disable\n");

$server = new Server();
$plugin = new Plugin($server);
$logger = $plugin->getLogger();
$config = $plugin->getConfig();
$url = $config->get("provisioner_url");

$plugin->clearLog("Cleared log on disable");

if ($server->delCSP("default-src", $url))
{
    $server->clearTwigCache();
    $logger->debug("Removed CSP frame-src for $url");
}

$server->moveClientServiceWidget(
    ClientServiceWidgets::PLUGIN_WIDGETS,
    ClientServiceWidgets::CHARTS
);

// Perform another registration to the provisioner.
$server->register($plugin, $plugin->getConfig()->get("provisioner_url"));

// Workflow Trigger
$response = $plugin->executeWorkflow("plugin/disabled", [], true);

// # region WebHook

// $ucrmDB = $server->getUcrmDB();
// $unmsDB = $server->getUnmsDB();

// $name = $plugin->getName();

// $hook = [
//     "url" => "http://localhost/crm/_plugins/$name/public.php?route=/webhook"
// ];

// $query = $ucrmDB->query(<<<SQL
//     SELECT * FROM webhook_address
//     WHERE url LIKE '%/crm/_plugins/$name/public.php?route=/webhook';
//     SQL
// );

// foreach($query->fetchAll() as $row)
// {
//     $webhook_address_id = $row["id"];

//     // webhook_event_request
//     $event_requests = $ucrmDB->query(<<<SQL
//         SELECT * FROM webhook_event_request
//         WHERE webhook_address_id = $webhook_address_id;
//         SQL
//     );

//     foreach($event_requests->fetchAll() as $event_request)
//     {
//         //        $json = json_decode($event_request["request_body"], true);
//         //        $uuid = $json["uuid"];
//         //        $ucrmDB->exec(<<<SQL
//         //            DELETE FROM webhook_event
//         //            WHERE uuid = '$uuid';
//         //            SQL
//         //        );
//         $ucrmDB->exec(<<<SQL
//             DELETE FROM webhook_event
//             WHERE id = '{$event_request["webhook_event_id"]}';
//             SQL
//         );
//     }

//     // webhook_scheduled_event_address
//     $ucrmDB->exec(<<<SQL
//         DELETE FROM webhook_scheduled_event_address
//         WHERE webhook_address_id = $webhook_address_id;
//         SQL
//     );

//     // webhook_event_request
//     $ucrmDB->exec(<<<SQL
//         DELETE FROM webhook_event_request
//         WHERE webhook_address_id = $webhook_address_id;
//         SQL
//     );

//     // webhook_address_webhook_event_type
//     $ucrmDB->exec(<<<SQL
//         DELETE FROM  webhook_address_webhook_event_type
//         WHERE webhook_address_id = $webhook_address_id;
//         SQL
//     );

//     // webhook_address
//     $ucrmDB->exec(<<<SQL
//         DELETE FROM webhook_address
//         WHERE id = $webhook_address_id;
//         SQL
//     );

//     $logger->debug("WebHook has been removed from the system.");
// }

// # endregion