<?php declare(strict_types=1);
/**
 * @author Ryan Spaeth <rspaeth@spaethtech.com>
 * @copyright 2025 - Spaeth Technologies, Archous Networks
 */

use GuzzleHttp\Client;
use Psr\Container\ContainerInterface;
use Psr\Http\Client\ClientInterface;
use Slim\Views\Twig;
use Slim\Views\TwigMiddleware;
use SpaethTech\UCRM\SDK\Plugin;
use SpaethTech\UCRM\SDK\Server;
use SpaethTech\UCRM\SDK\Controllers\BaseController;
use SpaethTech\UCRM\SDK\Controllers\ServicesCheckController;
use SpaethTech\UCRM\SDK\Controllers\ApiErrorController;
use SpaethTech\UCRM\SDK\Controllers\FallbackController;

require_once __DIR__ . "/bootstrap.php";

global $server;
global $plugin;
global $config;

return [
  "settings" => [
    "displayErrorDetails" => true,
    "addContentLengthHeader" => false,
  ],
  "twig" => [
    "cache" => false,
    "debug" => true,
    "auto_reload" => true,
    "autoescape" => "html",
    "strict_variables" => true,
    "optimizations" => -1,
  ],
  Twig::class => function (ContainerInterface $container) {
    $settings = $container->get("twig");
    return Twig::create(__DIR__ . "/views", ["cache" => $settings["cache"]]);
  },
  ClientInterface::class => fn() => new Client(),
  Server::class => function (ContainerInterface $container) {
    return new Server($container);
  },
  Plugin::class => function (ContainerInterface $container, Server $server) {
    return new Plugin($server);
  },
];